-- Habilitar Row Level Security (RLS) en todas las tablas
ALTER TABLE users ENABLE ROW LEVEL SECURITY;
ALTER TABLE products ENABLE ROW LEVEL SECURITY;
ALTER TABLE leads ENABLE ROW LEVEL SECURITY;
ALTER TABLE calls ENABLE ROW LEVEL SECURITY;
ALTER TABLE deals ENABLE ROW LEVEL SECURITY;
ALTER TABLE activities ENABLE ROW LEVEL SECURITY;

-- Políticas para users: Solo admin puede ver todos, los demás solo su perfil
CREATE POLICY "Users can view their own profile" ON users
  FOR SELECT USING (auth.uid() = id);

CREATE POLICY "Admins can view all users" ON users
  FOR SELECT USING (
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role = 'admin'
    )
  );

CREATE POLICY "Admins can insert users" ON users
  FOR INSERT WITH CHECK (
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role = 'admin'
    )
  );

CREATE POLICY "Admins can update users" ON users
  FOR UPDATE USING (
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role = 'admin'
    )
  );

-- Políticas para products: Todos pueden leer, solo admin puede modificar
CREATE POLICY "Everyone can view active products" ON products
  FOR SELECT USING (is_active = true);

CREATE POLICY "Admins can manage products" ON products
  FOR ALL USING (
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
    )
  );

-- Políticas para leads: Agentes ven sus leads asignados, supervisores y admins ven todo
CREATE POLICY "Agents can view their assigned leads" ON leads
  FOR SELECT USING (
    assigned_to = auth.uid() OR
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
    )
  );

CREATE POLICY "Agents can insert leads" ON leads
  FOR INSERT WITH CHECK (auth.uid() IS NOT NULL);

CREATE POLICY "Agents can update their assigned leads" ON leads
  FOR UPDATE USING (
    assigned_to = auth.uid() OR
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
    )
  );

-- Políticas para calls: Acceso basado en el lead asignado
CREATE POLICY "Users can view calls for their leads" ON calls
  FOR SELECT USING (
    EXISTS (
      SELECT 1 FROM leads WHERE leads.id = calls.lead_id AND 
      (leads.assigned_to = auth.uid() OR EXISTS (
        SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
      ))
    )
  );

CREATE POLICY "Users can insert calls" ON calls
  FOR INSERT WITH CHECK (auth.uid() IS NOT NULL);

-- Políticas para deals: Similar a leads
CREATE POLICY "Users can view deals for their leads" ON deals
  FOR SELECT USING (
    agent_id = auth.uid() OR
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
    )
  );

CREATE POLICY "Users can manage their deals" ON deals
  FOR ALL USING (
    agent_id = auth.uid() OR
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
    )
  );

-- Políticas para activities: Similar a calls
CREATE POLICY "Users can view activities for their leads" ON activities
  FOR SELECT USING (
    agent_id = auth.uid() OR
    EXISTS (
      SELECT 1 FROM leads WHERE leads.id = activities.lead_id AND 
      (leads.assigned_to = auth.uid() OR EXISTS (
        SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
      ))
    )
  );

CREATE POLICY "Users can manage their activities" ON activities
  FOR ALL USING (
    agent_id = auth.uid() OR
    EXISTS (
      SELECT 1 FROM users WHERE id = auth.uid() AND role IN ('admin', 'supervisor')
    )
  );
