import { Card } from "@/components/ui/card"
import { Users, Phone, TrendingUp, DollarSign, Target, BarChart3 } from "lucide-react"

interface OverviewStatsProps {
  totalLeads: number
  totalCalls: number
  totalDeals: number
  totalRevenue: number
  avgDealSize: number
  conversionRate: number
}

export function OverviewStats({
  totalLeads,
  totalCalls,
  totalDeals,
  totalRevenue,
  avgDealSize,
  conversionRate,
}: OverviewStatsProps) {
  const formatCurrency = (amount: number) => {
    return new Intl.NumberFormat("es-AR", {
      style: "currency",
      currency: "ARS",
      minimumFractionDigits: 0,
    }).format(amount)
  }

  const stats = [
    {
      label: "Total Leads",
      value: totalLeads,
      icon: Users,
      color: "text-blue-600",
      bg: "bg-blue-50",
    },
    {
      label: "Total Llamadas",
      value: totalCalls,
      icon: Phone,
      color: "text-green-600",
      bg: "bg-green-50",
    },
    {
      label: "Oportunidades",
      value: totalDeals,
      icon: TrendingUp,
      color: "text-purple-600",
      bg: "bg-purple-50",
    },
    {
      label: "Ingresos Totales",
      value: formatCurrency(totalRevenue),
      icon: DollarSign,
      color: "text-emerald-600",
      bg: "bg-emerald-50",
    },
    {
      label: "Ticket Promedio",
      value: formatCurrency(avgDealSize),
      icon: Target,
      color: "text-amber-600",
      bg: "bg-amber-50",
    },
    {
      label: "Conversión",
      value: `${conversionRate.toFixed(1)}%`,
      icon: BarChart3,
      color: "text-rose-600",
      bg: "bg-rose-50",
    },
  ]

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
      {stats.map((stat) => {
        const Icon = stat.icon
        return (
          <Card key={stat.label} className="p-4">
            <div className="flex items-start justify-between">
              <div>
                <p className="text-xs font-medium text-slate-600">{stat.label}</p>
                <p className="text-xl font-bold text-slate-900 mt-2">{stat.value}</p>
              </div>
              <div className={`${stat.bg} p-2 rounded-lg`}>
                <Icon className={`h-4 w-4 ${stat.color}`} />
              </div>
            </div>
          </Card>
        )
      })}
    </div>
  )
}
