import { Card } from "@/components/ui/card"
import { DollarSign, TrendingUp, Target, BarChart2 } from "lucide-react"

interface PipelineStatsProps {
  totalValue: number
  wonValue: number
  avgDealSize: number
  conversionRate: number
  dealsCount: number
}

export function PipelineStats({ totalValue, wonValue, avgDealSize, conversionRate, dealsCount }: PipelineStatsProps) {
  const formatCurrency = (amount: number) => {
    return new Intl.NumberFormat("es-AR", {
      style: "currency",
      currency: "ARS",
      minimumFractionDigits: 0,
    }).format(amount)
  }

  const stats = [
    {
      label: "Valor Total Pipeline",
      value: formatCurrency(totalValue),
      icon: DollarSign,
      color: "text-blue-600",
      bg: "bg-blue-50",
      subtitle: `${dealsCount} oportunidades`,
    },
    {
      label: "Ventas Cerradas",
      value: formatCurrency(wonValue),
      icon: TrendingUp,
      color: "text-green-600",
      bg: "bg-green-50",
      subtitle: "Este mes",
    },
    {
      label: "Ticket Promedio",
      value: formatCurrency(avgDealSize),
      icon: Target,
      color: "text-purple-600",
      bg: "bg-purple-50",
      subtitle: "Por oportunidad",
    },
    {
      label: "Tasa de Conversión",
      value: `${conversionRate.toFixed(1)}%`,
      icon: BarChart2,
      color: "text-amber-600",
      bg: "bg-amber-50",
      subtitle: "Cierre exitoso",
    },
  ]

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
      {stats.map((stat) => {
        const Icon = stat.icon
        return (
          <Card key={stat.label} className="p-6">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm font-medium text-slate-600">{stat.label}</p>
                <p className="text-2xl font-bold text-slate-900 mt-2">{stat.value}</p>
                <p className="text-xs text-slate-500 mt-1">{stat.subtitle}</p>
              </div>
              <div className={`${stat.bg} p-3 rounded-lg`}>
                <Icon className={`h-6 w-6 ${stat.color}`} />
              </div>
            </div>
          </Card>
        )
      })}
    </div>
  )
}
