"use client"

import { Card } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Button } from "@/components/ui/button"
import { Phone, Mail, Calendar, Eye } from "lucide-react"
import { format } from "date-fns"
import { es } from "date-fns/locale"
import Link from "next/link"

interface DealCardProps {
  deal: any
}

export function DealCard({ deal }: DealCardProps) {
  const formatCurrency = (amount: number) => {
    return new Intl.NumberFormat("es-AR", {
      style: "currency",
      currency: "ARS",
      minimumFractionDigits: 0,
    }).format(amount)
  }

  return (
    <Card className="p-4 hover:shadow-lg transition-shadow cursor-pointer">
      <div className="space-y-3">
        <div>
          <h4 className="font-semibold text-slate-900 mb-1">{deal.title}</h4>
          <p className="text-2xl font-bold text-blue-600">{formatCurrency(Number(deal.amount))}</p>
        </div>

        {deal.lead && (
          <div className="space-y-2">
            <p className="text-sm font-medium text-slate-700">
              {deal.lead.first_name} {deal.lead.last_name}
            </p>
            <div className="flex items-center gap-2 text-sm text-slate-600">
              <Phone className="h-3 w-3" />
              <span>{deal.lead.phone}</span>
            </div>
            {deal.lead.email && (
              <div className="flex items-center gap-2 text-sm text-slate-600">
                <Mail className="h-3 w-3" />
                <span className="truncate">{deal.lead.email}</span>
              </div>
            )}
          </div>
        )}

        {deal.product && (
          <div>
            <Badge variant="outline" className="text-xs">
              {deal.product.name}
            </Badge>
          </div>
        )}

        <div className="flex items-center justify-between pt-2 border-t border-slate-200">
          <div className="flex items-center gap-2 text-xs text-slate-500">
            <Calendar className="h-3 w-3" />
            {deal.expected_close_date
              ? format(new Date(deal.expected_close_date), "dd MMM", { locale: es })
              : "Sin fecha"}
          </div>
          <div className="flex items-center gap-1">
            <Badge variant="secondary" className="text-xs">
              {deal.probability}%
            </Badge>
            <Button variant="ghost" size="sm" asChild>
              <Link href={`/dashboard/deals/${deal.id}`}>
                <Eye className="h-3 w-3" />
              </Link>
            </Button>
          </div>
        </div>

        {deal.agent && <p className="text-xs text-slate-500">Agente: {deal.agent.full_name}</p>}
      </div>
    </Card>
  )
}
