import { Card } from "@/components/ui/card"
import { Users, UserPlus, UserCheck, Trophy } from "lucide-react"

interface LeadsStatsProps {
  total: number
  newLeads: number
  qualified: number
  won: number
}

export function LeadsStats({ total, newLeads, qualified, won }: LeadsStatsProps) {
  const stats = [
    {
      label: "Total Leads",
      value: total,
      icon: Users,
      color: "text-blue-600",
      bg: "bg-blue-50",
    },
    {
      label: "Nuevos",
      value: newLeads,
      icon: UserPlus,
      color: "text-green-600",
      bg: "bg-green-50",
    },
    {
      label: "Calificados",
      value: qualified,
      icon: UserCheck,
      color: "text-purple-600",
      bg: "bg-purple-50",
    },
    {
      label: "Ganados",
      value: won,
      icon: Trophy,
      color: "text-amber-600",
      bg: "bg-amber-50",
    },
  ]

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
      {stats.map((stat) => {
        const Icon = stat.icon
        return (
          <Card key={stat.label} className="p-6">
            <div className="flex items-center justify-between">
              <div>
                <p className="text-sm font-medium text-slate-600">{stat.label}</p>
                <p className="text-3xl font-bold text-slate-900 mt-2">{stat.value}</p>
              </div>
              <div className={`${stat.bg} p-3 rounded-lg`}>
                <Icon className={`h-6 w-6 ${stat.color}`} />
              </div>
            </div>
          </Card>
        )
      })}
    </div>
  )
}
