"use client"

import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"
import { useState } from "react"
import { CreateLeadDialog } from "./create-lead-dialog"

export function LeadsHeader() {
  const [open, setOpen] = useState(false)

  return (
    <>
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-3xl font-bold text-slate-900">Leads</h2>
          <p className="text-slate-600 mt-1">Gestiona y realiza seguimiento de tus clientes potenciales</p>
        </div>
        <Button onClick={() => setOpen(true)} className="gap-2">
          <Plus className="h-4 w-4" />
          Nuevo Lead
        </Button>
      </div>
      <CreateLeadDialog open={open} onOpenChange={setOpen} />
    </>
  )
}
