"use client"

import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"
import { useState } from "react"
import { LogCallDialog } from "./log-call-dialog"

export function CallsHeader() {
  const [open, setOpen] = useState(false)

  return (
    <>
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-3xl font-bold text-slate-900">Registro de Llamadas</h2>
          <p className="text-slate-600 mt-1">Registra y da seguimiento a todas tus llamadas con clientes</p>
        </div>
        <Button onClick={() => setOpen(true)} className="gap-2">
          <Plus className="h-4 w-4" />
          Registrar Llamada
        </Button>
      </div>
      <LogCallDialog open={open} onOpenChange={setOpen} />
    </>
  )
}
